/*
 * Copyright (c) 2016 Adobe Systems Incorporated. All rights reserved.
 *  
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *  
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *  
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 * 
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4,
maxerr: 50, node: true */
/*global */

(function () {
    "use strict";

    var net = require('net'),
        fs = require('fs'),
        EventEmitter    = require("events").EventEmitter,
        DWEvents        = require("./DWEvents");
    
    var _clientSocket = null;
    
    var _dwPort = 0;
    var _uuid = '',
        stringBuffer = "";
    
    function init(dwport, uuid) {
        _dwPort = parseInt(dwport, 10);
        _uuid = uuid;
    }
    
    function connect() {
        if (typeof _dwPort !== "number" && typeof _uuid !== "string") {
            return;
        }
        
        if (_clientSocket) {
            return;
        }
        
        _clientSocket = new net.Socket();
        _clientSocket.connect(_dwPort, '127.0.0.1', function () {
            console.log('Connected');
        });

        _clientSocket.on('data', function (data) {

            stringBuffer += data;
            var index = stringBuffer.indexOf(_uuid), encodedData;
            while (index > -1) {
                encodedData = stringBuffer.substring(0, index);
                DWEvents.processMessage(encodedData);
                stringBuffer = stringBuffer.slice(index + _uuid.length);
                index = stringBuffer.indexOf(_uuid);
            }
        });
        
        _clientSocket.on('close', function () {
            console.log('Connection closed');
            _clientSocket = null;
        });
    }
    
    /**
     * sends the js object to dreamweaver strigified as JSON
     * @param {string} messageID 
     * @param {object} obj      to send to dreamweaver
     */
    function sendJSObj(messageID, obj) {
        try {
            var dataToSend = {
                "messageId" : messageID,
                "Content-Type" : "application/json; charset=utf-8",
                "data" : JSON.stringify(obj)
            };
            _clientSocket.write(JSON.stringify(dataToSend) + _uuid);
        } catch (ex) {
        }
    }
    
    exports.init       = init;
    exports.connect    = connect;
    exports.sendJSObj  = sendJSObj;
    
}());
